#include <p30fxxxx.h>
#include <outcompare.h>

/* This devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/************************************************************************
*    Function Name:  ConfigIntOC7                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/

void ConfigIntOC7(unsigned int config)
{
    IFS2bits.OC7IF = 0;                    /* Clear IF bit */
    IPC8bits.OC7IP=(config &0x0007);       /* Assign Interrupt Priority */
    IEC2bits.OC7IE=(config &0x0008)>>3;    /* Enable/disable Interrupt */
}

#endif 
